#B) Model using the bookies as covariates
   #(answer to comment (F) of Reviewer 2)



p_norm_aggr_serieA=apply(p_norm_prob(array_odds_serieA,  agenzie, 
                         ngames_tot_serieA), c(1,3), mean)
p_norm_aggr_serieA_test <- p_norm_aggr_serieA[(ngames_train_serieA+1):ngames_tot_serieA,]

dati_serieA_covariates<-list(nteams=nteams_serieA,
  ngames_train=ngames_train_serieA,
  ngames_test=ngames_test_serieA,
  team1=team1_serieA,
  score1=score1_serieA,
  team2=team2_serieA,
  score2=score2_serieA,
  team1_prev=team1_prev_serieA,
  team2_prev=team2_prev_serieA,
  T=T,
  season=season_serieA,
  season_prev=season_prev_serieA,
  agenzie=agenzie,
  p_norm_aggr = p_norm_aggr_serieA,
  p_norm_aggr_test = p_norm_aggr_serieA_test)

p_norm_aggr_PL=apply(p_norm_prob(array_odds_PL,  agenzie, 
  ngames_tot_PL), c(1,3), mean)
p_norm_aggr_PL_test <- p_norm_aggr_PL[(ngames_train_PL+1):ngames_tot_PL,]

dati_PL_covariates<-list(nteams=nteams_PL,
  ngames_train=ngames_train_PL,
  ngames_test=ngames_test_PL,
  team1=team1_PL,
  score1=score1_PL,
  team2=team2_PL,
  score2=score2_PL,
  team1_prev=team1_prev_PL,
  team2_prev=team2_prev_PL,
  T=T,
  season=season_PL,
  season_prev=season_prev_PL,
  agenzie=agenzie,
  p_norm_aggr = p_norm_aggr_PL,
  p_norm_aggr_test = p_norm_aggr_PL_test)

p_norm_aggr_Liga=apply(p_norm_prob(array_odds_Liga,  agenzie, 
  ngames_tot_Liga), c(1,3), mean)
p_norm_aggr_Liga_test <- p_norm_aggr_Liga[(ngames_train_Liga+1):ngames_tot_Liga,]

dati_Liga_covariates<-list(nteams=nteams_Liga,
  ngames_train=ngames_train_Liga,
  ngames_test=ngames_test_Liga,
  team1=team1_Liga,
  score1=score1_Liga,
  team2=team2_Liga,
  score2=score2_Liga,
  team1_prev=team1_prev_Liga,
  team2_prev=team2_prev_Liga,
  T=T,
  season=season_Liga,
  season_prev=season_prev_Liga,
  agenzie=agenzie,
  p_norm_aggr = p_norm_aggr_Liga,
  p_norm_aggr_test = p_norm_aggr_Liga_test)

p_norm_aggr_BundesLiga=apply(p_norm_prob(array_odds_BundesLiga,  agenzie, 
  ngames_tot_BundesLiga), c(1,3), mean)
p_norm_aggr_BundesLiga_test <- p_norm_aggr_BundesLiga[(ngames_train_BundesLiga+1):ngames_tot_BundesLiga,]

dati_BundesLiga_covariates<-list(nteams=nteams_BundesLiga,
  ngames_train=ngames_train_BundesLiga,
  ngames_test=ngames_test_BundesLiga,
  team1=team1_BundesLiga,
  score1=score1_BundesLiga,
  team2=team2_BundesLiga,
  score2=score2_BundesLiga,
  team1_prev=team1_prev_BundesLiga,
  team2_prev=team2_prev_BundesLiga,
  T=T,
  season=season_BundesLiga,
  season_prev=season_prev_BundesLiga,
  agenzie=agenzie,
  p_norm_aggr = p_norm_aggr_BundesLiga,
  p_norm_aggr_test = p_norm_aggr_BundesLiga_test)


mod_with_covariates<-"model{
# Likelihood:

    for (n in 1:ngames_train){
        

  theta1_hat[n]<-thetaofClust[n,1] 
  theta2_hat[n]<-thetaofClust[n,2]


  score1[n] ~ dpois(theta1_hat[n])
  score2[n] ~ dpois(theta2_hat[n])


  log(thetaofClust[n,1])<-mu+att[team1[n], season[n]]+def[team2[n], season[n]]+
                                    alpha*p_norm_aggr[n,1]
  log(thetaofClust[n,2])<-att[team2[n], season[n]]+def[team1[n], season[n]]+
                                     beta*p_norm_aggr[n,3]

}

# Predictive distribution for the number of goals scored

  for (n in 1:ngames_test){
      
      theta1_hat_prev[n]<-thetaofClust_prev[n,1]
      theta2_hat_prev[n]<-thetaofClust_prev[n,2] 
      
      score1_prev[n] ~ dpois(theta1_hat_prev[n])
      score2_prev[n] ~ dpois(theta2_hat_prev[n])

      log(thetaofClust_prev[n,1])<-mu+att[team1_prev[n], season_prev[n]]+
                                     def[team2_prev[n], season_prev[n]]+
                                     alpha*p_norm_aggr_test[n,1]
      
      log(thetaofClust_prev[n,2])<-att[team2_prev[n], season_prev[n]]+
                                     def[team1_prev[n], season_prev[n]]+
                                     beta*p_norm_aggr_test[n,3]
      
 }

# Prior: BASIC MODEL FOR HYPERPARAMETERS
  for (t in 1:nteams){

      att.star[t,1]~ dnorm(mu.att, tau.att)
      def.star[t,1]~ dnorm(mu.def, tau.def)

      att[t,1] <- att.star[t,1] - mean(att.star[,1])
      def[t,1] <- def.star[t,1] - mean(def.star[,1])

  for (h in 2:T){

      att.star[t,h] ~ dnorm(mu.att+att.star[t,h-1],tau.att)
      def.star[t,h] ~ dnorm(mu.def+def.star[t,h-1],tau.def)

      att[t,h] <- att.star[t,h] - mean(att.star[,h])
      def[t,h] <- def.star[t,h] - mean(def.star[,h])
  }
}

# priors on the random effects

    mu.att ~ dnorm(0,0.0001)
    mu.def ~ dnorm(0,0.0001)
    tau.att ~ dgamma(.01,.01)
    tau.def ~ dgamma(.01,.01) 
    mu~ dnorm(0,0.0001)
    alpha~dunif(0,10)
    beta~dunif(0,10)
}"


moni_covariates<- c("thetaofClust", 
  "score1_prev", "score2_prev",
  "att","def", 
  "theta1_hat", "theta2_hat", "theta1_hat_prev", "theta2_hat_prev",
  "alpha", "beta")


init_serieA_covariates1<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_serieA_covariates2<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_serieA_covariates3<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))


library(parallel)
cl <- makeCluster(3)

serieA.jags.covariates<- run.jags(model=mod_with_covariates, 
  data=dati_serieA_covariates, 
  monitor=moni_covariates, 
  inits=list(init_serieA_covariates1,  init_serieA_covariates2, init_serieA_covariates3),
  n.chains=3, 
  method="rjparallel",
  plots=FALSE, thin=2,adapt=A, sample=M, burnin=B, cl = cl)

ris.serieA.covariates=serieA.jags.covariates$mcmc[[1]]
fattori_att_serieA.covariates<-ris.serieA.covariates[,grep("att[",colnames(ris.serieA.covariates),fixed=TRUE)] 
fattori_def_serieA.covariates<-ris.serieA.covariates[,grep("def[",colnames(ris.serieA.covariates),fixed=TRUE)]
previsioni1_serieA.covariates<-ris.serieA.covariates[,grep("score1_prev[",colnames(ris.serieA.covariates),fixed=TRUE)] 
previsioni2_serieA.covariates<-ris.serieA.covariates[,grep("score2_prev[",colnames(ris.serieA.covariates),fixed=TRUE)] 

alpha_serieA.covariates<-ris.serieA.covariates[,grep("alpha",colnames(ris.serieA.covariates),fixed=TRUE)] 
beta_serieA.covariates<-ris.serieA.covariates[,grep("beta",colnames(ris.serieA.covariates),fixed=TRUE)] 
mu_serieA.covariates<-ris.serieA.covariates[,grep("mu",colnames(ris.serieA.covariates),fixed=TRUE)] 

theta1_hat_serieA.covariates<-ris.serieA.covariates[,grep("theta1_hat[",colnames(ris.serieA.covariates),fixed=TRUE)]
theta2_hat_serieA.covariates<-ris.serieA.covariates[,grep("theta2_hat[",colnames(ris.serieA.covariates),fixed=TRUE)]
theta1_hat_prev_serieA.covariates<-ris.serieA.covariates[,grep("theta1_hat_prev[",colnames(ris.serieA.covariates),fixed=TRUE)] 
theta2_hat_prev_serieA.covariates<-ris.serieA.covariates[,grep("theta2_hat_prev[",colnames(ris.serieA.covariates),fixed=TRUE)] 
hat_theta1_serieA.covariates=apply(theta1_hat_serieA.covariates,2,mean)
hat_theta2_serieA.covariates=apply(theta2_hat_serieA.covariates,2,mean)
hat_theta1_prev_serieA.covariates=apply(theta1_hat_prev_serieA.covariates,2,mean)
hat_theta2_prev_serieA.covariates=apply(theta2_hat_prev_serieA.covariates,2,mean)
hat_theta1_serieA.covariates=as.vector(hat_theta1_serieA.covariates)
hat_theta2_serieA.covariates=as.vector(hat_theta2_serieA.covariates)
hat_theta1_prev_serieA.covariates=as.vector(hat_theta1_prev_serieA.covariates)
hat_theta2_prev_serieA.covariates=as.vector(hat_theta2_prev_serieA.covariates)


init_PL_covariates1<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_PL_covariates2<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_PL_covariates3<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))

PL.jags.covariates<- run.jags(model=mod_with_covariates, 
  data=dati_PL_covariates, 
  monitor=moni_covariates, 
  inits=list(init_PL_covariates1, init_PL_covariates2, init_PL_covariates3), 
  n.chains=3, 
  method="rjparallel",
  plots=FALSE, thin=2,adapt=A, sample=M, burnin=B, cl = cl)

ris.PL.covariates=PL.jags.covariates$mcmc[[1]]
fattori_att_PL.covariates<-ris.PL.covariates[,grep("att[",colnames(ris.PL.covariates),fixed=TRUE)] 
fattori_def_PL.covariates<-ris.PL.covariates[,grep("def[",colnames(ris.PL.covariates),fixed=TRUE)]
previsioni1_PL.covariates<-ris.PL.covariates[,grep("score1_prev[",colnames(ris.PL.covariates),fixed=TRUE)] 
previsioni2_PL.covariates<-ris.PL.covariates[,grep("score2_prev[",colnames(ris.PL.covariates),fixed=TRUE)] 

alpha_PL.covariates<-ris.PL.covariates[,grep("alpha",colnames(ris.PL.covariates),fixed=TRUE)] 
beta_PL.covariates<-ris.PL.covariates[,grep("beta",colnames(ris.PL.covariates),fixed=TRUE)] 
mu_PL.covariates<-ris.PL.covariates[,grep("mu",colnames(ris.PL.covariates),fixed=TRUE)] 

theta1_hat_PL.covariates<-ris.PL.covariates[,grep("theta1_hat[",colnames(ris.PL.covariates),fixed=TRUE)] theta2_hat_PL.covariates<-ris.PL.covariates[,grep("theta2_hat[",colnames(ris.PL.covariates),fixed=TRUE)] theta1_hat_prev_PL.covariates<-ris.PL.covariates[,grep("theta1_hat_prev[",colnames(ris.PL.covariates),fixed=TRUE)] 
theta2_hat_prev_PL.covariates<-ris.PL.covariates[,grep("theta2_hat_prev[",colnames(ris.PL.covariates),fixed=TRUE)] 
hat_theta1_PL.covariates=apPL.covariatesy(theta1_hat_PL.covariates,2,mean)
hat_theta2_PL.covariates=apPL.covariatesy(theta2_hat_PL.covariates,2,mean)
hat_theta1_prev_PL.covariates=apply(theta1_hat_prev_PL.covariates,2,mean)
hat_theta2_prev_PL.covariates=apply(theta2_hat_prev_PL.covariates,2,mean)
hat_theta1_PL.covariates=as.vector(hat_theta1_PL.covariates)
hat_theta2_PL.covariates=as.vector(hat_theta2_PL.covariates)
hat_theta1_prev_PL.covariates=as.vector(hat_theta1_prev_PL.covariates)
hat_theta2_prev_PL.covariates=as.vector(hat_theta2_prev_PL.covariates)


init_Liga_covariates1<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_Liga_covariates2<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_Liga_covariates3<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))

Liga.jags.covariates<- run.jags(model=mod_with_covariates, 
  data=dati_Liga_covariates, 
  monitor=moni_covariates, 
  inits=list(init_Liga_covariates1,  init_Liga_covariates2, init_Liga_covariates3),
  n.chains=3, 
  method="rjparallel",
  plots=FALSE, thin=2,adapt=A, sample=M, burnin=B,  cl = cl)

ris.Liga.covariates=Liga.jags.covariates$mcmc[[1]]
fattori_att_Liga.covariates<-ris.Liga.covariates[,grep("att[",colnames(ris.Liga.covariates),fixed=TRUE)] 
fattori_def_Liga.covariates<-ris.Liga.covariates[,grep("def[",colnames(ris.Liga.covariates),fixed=TRUE)]
previsioni1_Liga.covariates<-ris.Liga.covariates[,grep("score1_prev[",colnames(ris.Liga.covariates),fixed=TRUE)] 
previsioni2_Liga.covariates<-ris.Liga.covariates[,grep("score2_prev[",colnames(ris.Liga.covariates),fixed=TRUE)] 

alpha_Liga.covariates<-ris.Liga.covariates[,grep("alpha",colnames(ris.Liga.covariates),fixed=TRUE)] 
beta_Liga.covariates<-ris.Liga.covariates[,grep("beta",colnames(ris.Liga.covariates),fixed=TRUE)] 
mu_Liga.covariates<-ris.Liga.covariates[,grep("mu",colnames(ris.Liga.covariates),fixed=TRUE)] 

theta1_hat_Liga.covariates<-ris.Liga.covariates[,grep("theta1_hat[",colnames(ris.Liga.covariates),fixed=TRUE)] theta2_hat_Liga.covariates<-ris.Liga.covariates[,grep("theta2_hat[",colnames(ris.Liga.covariates),fixed=TRUE)] theta1_hat_prev_Liga.covariates<-ris.Liga.covariates[,grep("theta1_hat_prev[",colnames(ris.Liga.covariates),fixed=TRUE)] 
theta2_hat_prev_Liga.covariates<-ris.Liga.covariates[,grep("theta2_hat_prev[",colnames(ris.Liga.covariates),fixed=TRUE)] 
hat_theta1_Liga.covariates=apply(theta1_hat_Liga.covariates,2,mean)
hat_theta2_Liga.covariates=apply(theta2_hat_Liga.covariates,2,mean)
hat_theta1_prev_Liga.covariates=apply(theta1_hat_prev_Liga.covariates,2,mean)
hat_theta2_prev_Liga.covariates=apply(theta2_hat_prev_Liga.covariates,2,mean)
hat_theta1_Liga.covariates=as.vector(hat_theta1_Liga.covariates)
hat_theta2_Liga.covariates=as.vector(hat_theta2_Liga.covariates)
hat_theta1_prev_Liga.covariates=as.vector(hat_theta1_prev_Liga.covariates)
hat_theta2_prev_Liga.covariates=as.vector(hat_theta2_prev_Liga.covariates)



init_BundesLiga_covariates1<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_BundesLiga_covariates2<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))
init_BundesLiga_covariates3<-list(mu.att=rnorm(1), 
  mu.def=rnorm(1), mu=rnorm(1),tau.att=runif(1), tau.def=runif(1))

BundesLiga.jags.covariates<- run.jags(model=mod_with_covariates, 
  data=dati_BundesLiga_covariates, 
  monitor=moni_covariates, 
  inits=list(init_BundesLiga_covariates1,  init_BundesLiga_covariates2, init_BundesLiga_covariates3), 
  n.chains=3, 
  method="rjparallel",
  plots=FALSE, thin=2,adapt=A, sample=M, burnin=B, cl = cl)

ris.BundesLiga=BundesLiga.jags.covariates$mcmc[[1]]
fattori_att_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("att[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
fattori_def_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("def[",colnames(ris.BundesLiga.covariates),fixed=TRUE)]
previsioni1_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("score1_prev[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
previsioni2_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("score2_prev[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 

alpha_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("alpha",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
beta_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("beta",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
mu_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("mu",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 

theta1_hat_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("theta1_hat[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] theta2_hat_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("theta2_hat[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] theta1_hat_prev_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("theta1_hat_prev[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
theta2_hat_prev_BundesLiga.covariates<-ris.BundesLiga.covariates[,grep("theta2_hat_prev[",colnames(ris.BundesLiga.covariates),fixed=TRUE)] 
hat_theta1_BundesLiga.covariates=apply(theta1_hat_BundesLiga.covariates,2,mean)
hat_theta2_BundesLiga.covariates=apply(theta2_hat_BundesLiga.covariates,2,mean)
hat_theta1_prev_BundesLiga.covariates=apply(theta1_hat_prev_BundesLiga.covariates,2,mean)
hat_theta2_prev_BundesLiga.covariates=apply(theta2_hat_prev_BundesLiga.covariates,2,mean)
hat_theta1_BundesLiga.covariates=as.vector(hat_theta1_BundesLiga.covariates)
hat_theta2_BundesLiga.covariates=as.vector(hat_theta2_BundesLiga.covariates)
hat_theta1_prev_BundesLiga.covariates=as.vector(hat_theta1_prev_BundesLiga.covariates)
hat_theta2_prev_BundesLiga.covariates=as.vector(hat_theta2_prev_BundesLiga.covariates)


## DIC

DIC_serieA.covariates=extract(serieA.jags.covariates, "dic")
DIC_PL.covariates=extract(PL.jags.covariates, "dic")
DIC_Liga.covariates=extract(Liga.jags.covariates, "dic")
DIC_BundesLiga.covariates=extract(BundesLiga.jags.covariates, "dic")

